/*
 * written by Steven Chaitoff
 */



/*
* TIMED CAPTURE
*/


/*
* creates a "timer" using <canvas> class to indicate
* when timed captures will be taken.  Because of the
* exactness of the function, calls capture function
* itself when finished.
*/

Timer = {

ctx : null,
beep : 3000, // begin beeping after 3 seconds
time : 10000, // set timer for 10 seconds
start_time : 0,
interval : null,

start :
function() {
	if (expanded) { // if redoing timed capture
		Stretcher.stretch(); // unexpand stretcher
		setTimeout(function() { Timer.run(); }, 500); // wait until stretch is complete, and then start timer
	}
	else this.run();
},


run :
function() {
	this.toggle(1);
	this.ctx = document.getElementById('timercanvas').getContext('2d');
	this.ctx.fillStyle = 'rgb(255,255,0)';
	this.start_time = new Date().getTime(),
	optext.title = '';
	optext.innerHTML = '<span class="tint" style="cursor:hand;" onclick="Timer.cancel();">' + localize('cancel') + '</span>';
	this.interval = setInterval(function() { Timer.sweep(); }, 10),
},


toggle : 
function(on)
{
	flip_icon_display(!on); // disable ability to see preferences
	document.getElementById('b2').style.visibility = on?'hidden':'visible'; // remove the regular timer icon
	document.getElementById('timer').style.display = on?'block':'none'; // display graphical clock 'shell'
	document.getElementById('timercanvas').style.display = on?'block':'none'; // display the canvas graphics
},


cancel :
function() {
	clearInterval(this.interval);
	this.toggle(0);
	busy = false;
	optext.innerHTML = optext_main_status();
},


sweep :
function() {
	var now = new Date().getTime();
	if (this.time - now + this.start_time < this.beep && this.beep > 0) {
		document.getElementById('beep').Play();	// play a system sound
		this.beep -= 1000;
	}
	if (now - this.start_time >= this.time) {
		clearInterval(this.interval);
		this.toggle(0);
		Program.run();
	}
	this.ctx.beginPath();
	this.ctx.arc(12,12,12,-Math.PI/2,-Math.PI/2+2*Math.PI*(now-this.start_time)/this.time,false);
	this.ctx.lineTo(12,12);
	this.ctx.fillStyle = 'rgb(255,' + parseInt(255-255*(now-this.start_time)/this.time) + ',0)';
	this.ctx.fill();
}


};


